<?php
/****************************************
 * XKLog 后台管理页
 *
 * 此文件控制输出后台管理页
 *
 * 更新：2009-06-23
 * 版本：V1.0
 ****************************************/

require('../include/loader.php');
@header("content-Type: text/html; charset=utf-8");

if( !user_is_super_admin() ){
	//SafeLogger("试图直接访问后台页面 Admin_Welcome.asp 。")
	//SafeDefender()
	show_admin_message( '您尚未登录，或者登录已过期' );
	exit;
}

$action = getGP( 'action', 'G' );

switch( $action )
{
    case 'EditSet':
        edit_set();
    	break;
    case 'AddMenu':
        add_menu();
    	break;
    case 'EditMenuExe':
        edit_menu_exe();
    	break;
    case 'DelMenu':
       	del_menu();
    	break;
    case 'ReBuildExe':
       	rebuild_exe();
       	break;
}

function edit_set() {
	global $db;
	$blog_name = getGP( 'BlogName','P' );
	$description = getGP( 'BlogDescription','P' );
	$key_words = getGP( 'BlogKeyWords','P' );
	$beian = getGP( 'BlogBeiAn','P' );
	$domain = getGP( 'BlogDomain','P' );
	$max_per_page = getGP( 'BlogMaxPerPage','P','int' );
	$max_online = getGP( 'BlogMaxOnline','P','int' );
	if( $max_online < 5 ) $max_online = 5;
	$filter_words = getGP( 'BlogFilterWords','P' );
	$name_filter = getGP( 'BlogNameFilter','P' );
	if( getGP( 'BlogEnable','P') == 1 ) {
		$enable = 1;
	}else{
		$enable = 0;
	}
	$close_reason = getGP( 'BlogCloseReason','P' );
	if( getGP( 'BlogRegEnable','P') == 1 ) {
		$reg_enable = 1;
	}else{
		$reg_enable = 0;
	}
	$comment = getGP( 'BlogComment','P','int' );
	$comment_timer = getGP( 'BlogComTimer','P','int' );
	$comment_max_length = getGP( 'BlogComMaxLength','P','int' );
	$comment_num = getGP( 'BlogComNum','P','int' );
	$art_type = getGP( 'BlogArticleType','P' );
	$art_max_length = getGP( 'BlogArtMaxLength','P','int' );
	$show_type = getGP( 'BlogShowType','P','int' );
	$verify = getGP( 'Verify','P','int' );
	$db->query( "UPDATE `" . PREFIX_STR . "Set` SET BlogName='$blog_name',Description='$description',KeyWords='$key_words',BeiAn='$beian',Domain='$domain',MaxPerPage=$max_per_page,MaxOnline=$max_online,FilterWords='$filter_words',NameFilter= '$name_filter',Enable=$enable,CloseReason='$close_reason',RegEnable=$reg_enable,Comment=$comment,ComNum=$comment_num,ComTimer=$comment_timer,ComMaxLength=$comment_max_length,ArtMaxLength=$art_max_length,ArtType='$art_type',ShowType=$show_type,Verify=$verify" );
	cache_set();
	show_admin_message( '基本设置修改成功', 'admin_set.php' );
	exit;
}

function add_menu() {
	global $db;
	$name = trim( getGP( 'Name','P' ) );
	$address = trim( getGP( 'Address','P' ) );
	$title = trim( getGP( 'Title','P' ) );
	$type = getGP( 'Type','P','int' );
	$num = getGP( 'Num','P','int' );
	if( $name == '' || $address == '' || $title == '' ) {
		echo "<script language=javascript>alert( '错误：您的输入不完整！' );location.href = 'javascript:history.back()'</script>";
		exit;
	}
	if( $db->result( "select count(MID) from `" . PREFIX_STR . "Menu` where Name='$name'" ) ) {
		show_admin_message( '导航栏项目名称重复，添加失败', 'admin_set.php?action=Menu' );
		exit;
	}
	$db->query( "INSERT INTO `" . PREFIX_STR . "Menu` (`Num`,`Name`,`Title`,`Type`,`Address`) VALUES ($num,'$name','$title',$type,'$address')" );
	cache_menu();
	show_admin_message( '添加导航栏项目成功', 'admin_set.php?action=Menu' );
	exit;
}

function edit_menu_exe() {
	global $db;
	$id = getGP( 'id', 'G', 'int');
	if( $id == 1 || $id == 2 || $id == 3 ) {
		show_admin_message( "此项目不允许编辑", "admin_set.php?action=Menu" );
	}else{
		$title = trim( getGP( 'Title', 'P') );
		$type = getGP( 'Type', 'P','int');
		$num = getGP( 'Num', 'P','int');
		$address = trim( getGP( 'Address', 'P') );
		if( $address == '' || $title == '' ) {
			echo "<script language=javascript>alert( '错误：您的输入不完整！' );location.href = 'javascript:history.back()'</script>";
			exit;
		}
		$db->query( "UPDATE `" . PREFIX_STR . "Menu` SET Title='$title', Type=$type, Num=$num, Address='$address' WHERE MID=$id" );
		cache_menu();
		show_admin_message( "编辑导航栏项目成功", "admin_set.php?action=Menu" );
	}
	exit;
}

function del_menu() {
	global $db;
	$id = getGP( 'id', 'G', 'int');
	if( $id == 1 || $id == 2 || $id == 3 ) {
		show_admin_message( "此项目不允许删除", "admin_set.php?action=Menu" );
	}else{
		$sql = "DELETE FROM `" . PREFIX_STR . "Menu` WHERE MID=$id";
		$db->query( $sql );
		cache_menu();
		show_admin_message( "删除导航栏项目成功", "admin_set.php?action=Menu" );
	}
	exit;
}

function rebuild_exe() {
	cache_load();
	show_admin_message( "重建系统缓存成功", get_http_referer() );
	exit;
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns = "http://www.w3.org/1999/xhtml" lang = "zh-cn">
<head>
	<meta http-equiv = "Content-Type" content = "text/html; charset=UTF-8" />
	<meta http-equiv = "Content-Language" content = "UTF-8" />
	<title><?php echo $_CACHE['set'][0]['BlogName'] ?> - 后台管理</title>
	<link rel = "stylesheet" type = "text/css" href = "../Include/Style.css" />
	<script language="javascript" type="text/javascript" src="../Include/admin.js"></script>
</head>
<body id = "Admin_Body">
<div id = "Admin_Main">
<center>

	<div class = "Admin_Panel">
		<div class = "Admin_Title">基本设置</div>
		<div class = "Admin_Content">
		<div style="padding:5px;margin:2px;border:1px solid #96C2F1;background-color: #EFF7FF;"><a href="admin_set.php">基本设置</a> | <a href="admin_set.php?action=Menu">导航设置</a> | <a href="admin_set.php?action=ReBuild">重建缓存</a></div>
<?php

switch( $action )
{
    case 'Menu':
        menu();
    	break;
    case 'EditMenu':
        edit_menu();
    	break;
    case 'ReBuild':
        rebuild();
    	break;
	default:
		main();
}

function main() {
	global $_CACHE;
?>
		<form action="admin_set.php?action=EditSet" method="post">
			<fieldset>
			<legend> 基本信息</legend>
				<div align="left">      
					<table border="0" cellpadding="2" cellspacing="1">
						<tr>
							<td width="180"><div align="right">博客名称&nbsp;&nbsp;</div></td>
							<td align="left"><input name="BlogName" type="text" size="30" class="Main_Text" value="<?php echo $_CACHE['set'][0]['BlogName']; ?>"/></td>
						</tr>
						<tr>
							<td width="180"><div align="right">博客描述&nbsp;&nbsp;</div></td>
							<td align="left"><input name="BlogDescription" type="text" size="50" class="Main_Text" value="<?php echo $_CACHE['set'][0]['Description']; ?>"/></td>
						</tr>
						<tr>
							<td width="180"><div align="right">博客关键词&nbsp;&nbsp;<div class="Main_Tips">帮助搜索引擎收录您的博客&nbsp;&nbsp;</div></div></td>
							<td align="left"><input name="BlogKeyWords" type="text" size="50" class="Main_Text" value="<?php echo $_CACHE['set'][0]['KeyWords']; ?>"/></td>
						</tr>
						<tr>
							<td width="180"><div align="right">博客地址&nbsp;&nbsp;<div class="Main_Tips">关系到<b>RSS</b>地址的可读性&nbsp;&nbsp;</div></div></td>
							<td align="left"><input name="BlogDomain" type="text" size="50" class="Main_Text" value="<?php echo $_CACHE['set'][0]['Domain']; ?>"/></td>
						</tr>
						<tr>
							<td width="180"><div align="right">备案信息&nbsp;&nbsp;</div></td>
							<td align="left"><input name="BlogBeiAn" type="text" size="50" class="Main_Text" value="<?php echo $_CACHE['set'][0]['BeiAn']; ?>"/></td>
						</tr>
						<tr>
							<td width="180"><div align="right">最大在线人数&nbsp;&nbsp;<div class="Main_Tips">此项设置小于5无效&nbsp;&nbsp;</div></div></td>
							<td align="left"><input name="BlogMaxOnline" type="text" size="50" class="Main_Text" value="<?php echo $_CACHE['set'][0]['MaxOnline']; ?>" /></td>
						</tr>
						<tr>
							<td><div align="right">是否开放博客&nbsp;&nbsp;</div></td>
							<td align="left"><input name="BlogEnable" type="checkbox" value="1" <?php if( $_CACHE['set'][0]['Enable'] ) echo 'checked="checked"'; ?> /></td>
						</tr>
						<tr>
							<td width="180"><div align="right">博客关闭原因&nbsp;&nbsp;</div></td>
							<td align="left"><input name="BlogCloseReason" type="text" size="50" class="Main_Text" value="<?php echo $_CACHE['set'][0]['CloseReason']; ?>" /></td>
						</tr>
					</table>
				</div>
			</fieldset>
			<fieldset>
			<legend> 日志设置</legend>
				<div align="left">
					<table border="0" cellpadding="2" cellspacing="1">
						<tr><td width="180" align="right">每页显示日志&nbsp;&nbsp;<div class="Main_Tips">此项设置亦适用于留言&nbsp;&nbsp;</div></td><td width="300"><input name="BlogMaxPerPage" type="text" size="5" class="Main_Text" value="<?php echo $_CACHE['set'][0]['MaxPerPage'] ?>"/> 篇</td></tr>
						<tr><td width="180" align="right">默认显示模式&nbsp;&nbsp;</td><td width="300"><input type="radio" value="0" name="BlogShowType" <?php if( $_CACHE['set'][0]['ShowType'] == 0 ) echo 'checked="checked"'; ?> />普通 <input type="radio" value="1" name="ShowType" <?php if( $_CACHE['set'][0]['ShowType'] == 1 ) echo 'checked="checked"'; ?> />列表</td></tr>
						<tr><td width="180" align="right">默认日志类型&nbsp;&nbsp;<div class="Main_Tips">写日志时您可以重新设置类型&nbsp;&nbsp;</div></td><td width="300"><input type="radio" value="静态" name="BlogArticleType" <?php if( $_CACHE['set'][0]['ArtType'] == "静态" ) echo 'checked="checked"'; ?> />静态 <input type="radio" value="半静态" name="BlogArticleType" <?php if( $_CACHE['set'][0]['ArtType'] == "半静态" ) echo 'checked="checked"'; ?> />半静态 <input type="radio" value="动态" name="BlogArticleType" <?php if( $_CACHE['set'][0]['ArtType'] == "动态" ) echo 'checked="checked"'; ?> />动态</td></tr>
						<tr><td width="180" align="right">字数限制&nbsp;&nbsp;<div class="Main_Tips">设置此项是为了保护您的数据库&nbsp;&nbsp;</div></td><td width="300"><input name="BlogArtMaxLength" type="text" size="5" class="Main_Text" value="<?php echo $_CACHE['set'][0]['ArtMaxLength'] ?>"/> 字</td></tr>
					</table>
				</div>
			</fieldset>
			<fieldset>
			<legend> 评论与留言设置</legend>
				<div align="left">
					<table border="0" cellpadding="2" cellspacing="1">
						<tr><td width="180" align="right">是否开放评论与留言&nbsp;&nbsp;</td><td width="300"><input type="radio" value="0" name="BlogComment" <?php if( $_CACHE['set'][0]['Comment'] == 0 ) echo 'checked="checked"'; ?> />是 <input type="radio" value="1" name="BlogComment" <?php if( $_CACHE['set'][0]['Comment'] == 1 ) echo 'checked="checked"'; ?> />仅用户 <input type="radio" value="2" name="BlogComment" <?php if( $_CACHE['set'][0]['Comment'] == 2 ) echo 'checked="checked"'; ?> />否</td></tr>
						<tr><td width="180" align="right">时间间隔&nbsp;&nbsp;<div class="Main_Tips">此项设置亦适用于搜索&nbsp;&nbsp;</div></td><td width="300"><input name="BlogComTimer" type="text" size="5" class="Main_Text" value="<?php echo $_CACHE['set'][0]['ComTimer'] ?>"/> 秒</td></tr>
						<tr><td width="180" align="right">字数限制&nbsp;&nbsp;</td><td width="300"><input name="BlogComMaxLength" type="text" size="5" class="Main_Text" value="<?php echo $_CACHE['set'][0]['ComMaxLength'] ?>"/> 字</td></tr>
						<tr><td width="180" align="right">评论显示数量&nbsp;&nbsp;<div class="Main_Tips">设置 0 输出全部评论&nbsp;&nbsp;</div></td><td width="300"><input name="BlogComNum" type="text" size="5" class="Main_Text" value="<?php echo $_CACHE['set'][0]['ComNum'] ?>"/> 条</td></tr>
						<tr><td width="180" align="right">是否需要验证码&nbsp;&nbsp;</td><td width="300"><input type="radio" value="0" name="Verify" <?php if( $_CACHE['set'][0]['Verify'] == 0 ) echo 'checked="checked"'; ?> />是 <input type="radio" value="1" name="Verify" <?php if( $_CACHE['set'][0]['Verify'] == 1 ) echo 'checked="checked"'; ?> />仅游客 <input type="radio" value="2" name="Verify" <?php if( $_CACHE['set'][0]['Verify'] == 2 ) echo 'checked="checked"'; ?> />否 </td></tr>
					</table>
				</div>
			</fieldset>
			<fieldset>
			<legend> 词过滤设置</legend>
				<div align="left">
					<table border="0" cellpadding="2" cellspacing="1">
						<tr><td width="180" valign="top"><div align="right">需要过滤关键词&nbsp;&nbsp;<div class="Main_Tips">用"|"分割需要过滤的关键词&nbsp;&nbsp;<br/>注意不要过滤常用的词&nbsp;&nbsp;</div></div><td align="left"><textarea name="BlogFilterWords" cols="50" rows="5"><?php echo $_CACHE['set'][0]['FilterWords'] ?></textarea></td></td></tr>
					</table>
				</div>
			</fieldset>
			<fieldset>
			<legend> 用户注册设置</legend>
				<div align="left">
					<table border="0" cellpadding="2" cellspacing="1">
						<tr><td width="180" align="right">是否允许注册新用户&nbsp;&nbsp;</td><td width="300"><input name="BlogRegEnable" type="checkbox" value="1" <?php if( $_CACHE['set'][0]['RegEnable'] ) echo 'checked="checked"'; ?> /> </td></tr>
						<tr><td width="180" valign="top"><div align="right">注册名过滤&nbsp;&nbsp;<div class="Main_Tips">用"|"分割需要过滤的名字&nbsp;&nbsp;</div></div><td align="left"><textarea name="BlogNameFilter" cols="50" rows="5"><?php echo $_CACHE['set'][0]['NameFilter']; ?></textarea></td></td></tr>
					</table>
				</div>
			</fieldset>
			<div class="Main_Button"><input type="submit" name="functionmit" class="Main_Button" value="保存配置" /></div>
		</form>
<?php
}

function menu() {
	global $db;
	$sql = 'select * from ' . PREFIX_STR . 'Menu order by Num asc,MID desc';
	$menu_array = $db->fetch_all( $sql );
?>
			<div style="padding:5px;margin:2px;">
				<table style="table-layout: fixed;word-wrap: break-word;" width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="b5d6e6" onmouseover="changeto()" onmouseout="changeback()">
					<tr align="center" height="22" bgcolor="#ffffff">
						<td width="3%"  background="../Include/bg.gif"></td>
						<td width="3%"  background="../Include/bg.gif">序号</td>
						<td width="10%" background="../Include/bg.gif">项目名称</td>
						<td width="10%" background="../Include/bg.gif">项目标题</td>
						<td width="7%"  background="../Include/bg.gif">项目排序</td>
						<td width="10%" background="../Include/bg.gif">链接类型</td>
						<td width="44%" background="../Include/bg.gif">链接地址</td>
						<td width="13%" background="../Include/bg.gif">管理操作</td>
					</tr>
					<?php
					$i = 1;
					foreach( $menu_array as $value ) {
					?>
					<tr align="center" height="20" bgcolor="#ffffff">
						<td ></td>
						<td><?php echo $i ?></td>
						<td><?php echo $value["Name"] ?></td>
						<td><?php echo $value["Title"] ?></td>
						<td><?php echo $value["Num"] ?></td>
						<?php
						If( $value["Type"] == 0 ) {
							$menu_type = "站内链接";
						}else{
							$menu_type = "站内链接";
						}
						?>
						<td><?php echo $menu_type ?></td>
						<td><?php echo $value["Address"] ?></td>
						<td>
							<span class="Control">
								<img src="../Include/edt.gif" width="16" height="16" /><a href="admin_set.php?action=EditMenu&id=<?php echo $value['MID'] ?>">编辑</a>&nbsp; &nbsp;
								<img src="../Include/del.gif" width="16" height="16" /><a href="javascript:if(confirm('删除后将不可恢复！确实要删除吗?'))location='admin_set.php?action=DelMenu&id=<?php echo $value['MID'] ?>'">删除</a>
							</span>
						</td>
					</tr>
					<?php
						$i ++;
					}
					?>
				</table>
			</div>

			<fieldset>
			<legend> 添加项目</legend>
				<div align="left">      
				<table border="0" cellpadding="2" cellspacing="1">
					<form name="smslist" action="admin_set.php?action=AddMenu" method="post">
					<tr>
						<td width="180"><div align="right">项目名称&nbsp;&nbsp;</div></td>
						<td align="left"><input name="Name" type="text" size="30" maxlength="50" class="Main_Text" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right">项目标题&nbsp;&nbsp;</div></td>
						<td align="left"><input name="Title" type="text" size="30" maxlength="100" class="Main_Text" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right">项目排序&nbsp;&nbsp;<div class="Main_Tips">必须是大于0的数字&nbsp;&nbsp;</div></div></td>
						<td align="left"><input name="Num" type="text" size="30" maxlength="5" class="Main_Text" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right">项目地址&nbsp;&nbsp;<div class="Main_Tips">站内链接请使用相对地址&nbsp;&nbsp;<br />站外链接请以"http://"开头&nbsp;&nbsp;</div></div></td>
						<td align="left"><input name="Address" type="text" size="30" maxlength="100" class="Main_Text" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right">链接类型&nbsp;&nbsp;</div></td>
						<td align="left"><input type="radio" value="0" name="Type" checked="checked" />站内链接 <input type="radio" value="1" name="Type" />站外连接</td>
					</tr>
					<tr>
						<td width="180"><div align="right"></div></td>
						<td align="left"><input type="submit" name="functionmit" class="Main_Button" value="添加" /></td>
					</tr>
				</form>
				</table>
			</fieldset>
			<div class="Main_Button"></div>
<?php
}

function edit_menu() {
	global $db;
	$id = getGP( 'id', 'G', 'int');
	if( $id == 1 || $id == 2 || $id == 3 ) {
		obclean();
		show_admin_message( '这是系统项目，不允许编辑', 'admin_set.php?action=Menu' );
		exit;
	}else{
		$sql = "select * from " . PREFIX_STR . "Menu where MID=$id";
		$menu_item = $db->fetch_one_array( $sql );
?>
			<fieldset>
			<legend> 编辑导航栏项目</legend>
				<div align="left">      
				<table border="0" cellpadding="2" cellspacing="1">
					<form name="smslist" action="admin_set.php?action=EditMenuExe&id=<?php echo $id ?>" method="post">
					<tr>
						<td width="180"><div align="right">项目名称&nbsp;&nbsp;</div></td>
						<td align="left"><?php echo $menu_item ['Name'] ?></td>
					</tr>
					<tr>
						<td width="180"><div align="right">项目标题&nbsp;&nbsp;</div></td>
						<td align="left"><input name="Title" type="text" size="30" maxlength="100" class="Main_Text" value="<?php echo $menu_item ['Title'] ?>" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right">项目排序&nbsp;&nbsp;<div class="Main_Tips">必须是大于0的数字&nbsp;&nbsp;</div></div></td>
						<td align="left"><input name="Num" type="text" size="30" maxlength="5" class="Main_Text" value="<?php echo $menu_item ['Num'] ?>" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right">项目地址&nbsp;&nbsp;<div class="Main_Tips">站内链接请使用相对地址&nbsp;&nbsp;<br />站外链接请以"http://"开头&nbsp;&nbsp;</div></div></td>
						<td align="left"><input name="Address" type="text" size="30" maxlength="100" class="Main_Text" value="<?php echo $menu_item ['Address'] ?>" /></td>
					</tr>
					<tr>
						<td width="180"><div align="right">链接类型&nbsp;&nbsp;</div></td>
						<td align="left"><input type="radio" value="0" name="Type" <?php if( $menu_item ['Type'] == 0 ) echo 'checked="checked"'; ?> />站内链接 <input type="radio" value="1" name="Type" <?php if( $menu_item ['Type'] == 1 ) echo 'checked="checked"'; ?> />站外连接</td>
					</tr>
					<tr>
						<td width="180"><div align="right"></div></td>
						<td align="left"><input type="submit" name="functionmit" class="Main_Button" value="修改" /></td>
					</tr>
				</form>
				</table>
			</fieldset>
			<div class="Main_Button"></div>
<?php
	}
}

function rebuild() {
?>
		<div style="padding:10px;">
			<a href="admin_set.php?action=ReBuildExe">重建系统缓存</a>
		</div>
<?php
}

?>
		</div>
	</div>

	<div id="Foot"><?php show_run_info() ?></div>
</center>
</div>
</body>
</html>